// UpgradeHint.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "UpgradeHint.h"
#include "Include\CommonFun.h"

// CUpgradeHint dialog

IMPLEMENT_DYNAMIC(CUpgradeHint, CDialog)

CUpgradeHint::CUpgradeHint(CWnd* pParent /*=NULL*/)
	: CDialog(CUpgradeHint::IDD, pParent),m_iUseTimer(0)
{
    m_iStart = 0;
    m_iEnd   = 100;
}

CUpgradeHint::~CUpgradeHint()
{
}

void CUpgradeHint::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PROGRESS_UPGRADE, m_ProgressUpgrade);
}


BEGIN_MESSAGE_MAP(CUpgradeHint, CDialog)
	ON_WM_TIMER()
	ON_WM_DESTROY()
END_MESSAGE_MAP()


// CUpgradeHint message handlers

BOOL CUpgradeHint::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
    m_ProgressUpgrade.SetRange32 ( m_iStart, m_iEnd ) ;
	m_ProgressUpgrade.SetPos ( 1 ) ;
	m_ProgressUpgrade.SetStep ( 1 ) ;
	if (m_iUseTimer)
	{
		SetTimer ( TIMER_UPGRADE, 100, NULL ) ;
	}
	SetDlgItemText(IDC_STATIC_UPGRADEHINT, GetText(IDS_MSP_TIP_UPGRADE));

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CUpgradeHint::OnTimer(UINT_PTR nIDEvent)
{
	if ( nIDEvent == TIMER_UPGRADE )
	{
		// ȡõǰ
		int nCurPos1 = this->m_ProgressUpgrade.GetPos () ;
		if ( nCurPos1 >= m_iEnd )
		{
			nCurPos1 = 0;
		}
		if ( nCurPos1 < m_iEnd )
		    m_ProgressUpgrade.SetPos ( nCurPos1 + 1 ) ;
		this->UpdateData ( FALSE ) ;
	}
	CDialog::OnTimer(nIDEvent);
}

void CUpgradeHint::OnDestroy()
{
	CDialog::OnDestroy();
	if (m_iUseTimer)
	{
        KillTimer ( 1 );
	}
	// TODO: Add your message handler code here
	EndDialog(0);
}

int CUpgradeHint::ProgressNotify(int _iProgress)
{
	if (0 > _iProgress)
	{
		_iProgress = 0;
	}
	if (100 < _iProgress)
	{
		_iProgress = 100;
	}
	m_ProgressUpgrade.SetPos ( _iProgress ) ;

	return 0;
}
